<?

/*
This is callback page for Trusted.Id Social Service authentication.
Google redirects only to specific back url set in the OAuth application.
The page opens in popup window after user authorized on Google.
*/
define("NOT_CHECK_PERMISSIONS", true);

use Bitrix\Main\Page\Asset;
use Bitrix\Main\Localization\Loc;

$provider = "Trusted.Id";
if(isset($_REQUEST["state"]) && is_string($_REQUEST["state"]))
{
	$arState = array();
	parse_str($_REQUEST["state"], $arState);

	if(isset($arState['site_id']) && is_string($arState['site_id']))
	{
		$site = mb_substr(preg_replace("/[^a-z0-9_]/i", "", $arState['site_id']), 0, 2);
		define("SITE_ID", $site);
	}
}

define('SOCSERV_CURRENT_PROVIDER', $provider);

require_once($_SERVER['DOCUMENT_ROOT'] . "/bitrix/modules/main/include/prolog_before.php");

CModule::IncludeModule("socialservices");

Loc::loadLanguageFile($_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/trusted.idsocserv/install/tools/oauth/trustedid.php");

if (isset($_REQUEST["auth_service_error"]))
{
	$messageType = "TR_IDSOCSERV_SOCSERV_DEFAULT_ERROR";
	switch ($_REQUEST["auth_service_error"]) {
		case SOCSERV_AUTHORISATION_ERROR:
			$messageType = "TR_IDSOCSERV_SOCSERV_AUTHORISATION_ERROR";
			break;
		case SOCSERV_REGISTRATION_DENY:
			$messageType = "TR_IDSOCSERV_SOCSERV_REGISTRATION_DENY";
			break;
		case SOCSERV_DEFAULT_HTTP_TIMEOUT:
			$messageType = "TR_IDSOCSERV_SOCSERV_DEFAULT_HTTP_TIMEOUT";
			break;
		case SOCSERV_TOO_MANY_USERS_EXIST:
			$messageType = "TR_IDSOCSERV_SOCSERV_TOO_MANY_USERS_EXIST";
			break;
		default:
			$messageType = "TR_IDSOCSERV_SOCSERV_DEFAULT_ERROR";
	}

	Asset::getInstance()->addCss("/bitrix/themes/.default/trusted.idsocserv.css");
	echo Asset::getInstance()->getCss();

	ShowError(GetMessage($messageType), "trusted_idsocserv_error");
	die;
}

if(Bitrix\Main\Loader::includeModule("socialservices"))
{
	$oAuthManager = new CSocServAuthManager();
	$oAuthManager->Authorize(SOCSERV_CURRENT_PROVIDER);
}

require_once($_SERVER['DOCUMENT_ROOT'] . "/bitrix/modules/main/include/epilog_after.php");
?>
