<?php

use Bitrix\Main\Loader;
use Trusted\IdSocServ\Utils;

Loader::includeModule('trusted.idsocserv');
$moduleId = 'trusted.idsocserv';
IncludeModuleLangFile(__FILE__);

$aTabs = array(
	array(
		'DIV' => 'tab_settings',
		'TAB' => GetMessage('TR_IDSOCSERV_OPTIONS_TAB_SETTINGS'),
		'TITLE' => GetMessage('TR_IDSOCSERV_OPTIONS_TAB_SETTINGS_TITLE')
	),
);

$tabControl = new CAdminTabControl('trustedTabControl', $aTabs, true, true);

if ($_SERVER['REQUEST_METHOD'] == 'POST' && check_bitrix_sessid()) {
	if (isset($_POST["tr_idsocserv_service_name"]) && is_string($_POST["tr_idsocserv_service_name"])) {
		Utils::setServiceName($_POST["tr_idsocserv_service_name"]);
	}

	if (isset($_POST["tr_idsocserv_service_logo"]) && is_string($_POST["tr_idsocserv_service_logo"])) {
		Utils::setServiceLogo($_POST["tr_idsocserv_service_logo"]);
	}
}

$TR_IDSOCSERV_SERVICE_NAME = Utils::getServiceName();
$TR_IDSOCSERV_SERVICE_LOGO = Utils::getServiceLogo();

CAdminFileDialog::ShowScript(
	[
		"event"            => "TrIdSocServ_ServiceLogo_BtnClick",
		"arResultDest"     => ["FORM_NAME" => "tr_idsocserv_settings", "FORM_ELEMENT_NAME" => "tr_idsocserv_service_logo"],
		"arPath"           => ["PATH" => GetDirPath($TR_IDSOCSERV_SERVICE_LOGO)],
		"select"           => 'F',// F - file only, D - folder only
		"operation"        => 'O',// O - open, S - save
		"showUploadTab"    => true,
		"showAddToMenuTab" => false,
		"fileFilter"       => 'jpg,jpeg,gif,png,svg',
		"allowAllFiles"    => true,
		"SaveConfig"       => true,
	]
);

$tabControl->Begin();

?>


<form method="POST" action="<?= $APPLICATION->GetCurPage(); ?>?lang=<?= LANGUAGE_ID; ?>&mid=<?= $moduleId; ?>" id="tr_idsocserv_settings" name="tr_idsocserv_settings">
	<? $tabControl->BeginNextTab(); ?>

	<? echo bitrix_sessid_post(); ?>

    <tr>
        <td width="40%" class="adm-detail-content-cell-l">
            <strong><?= GetMessage('TR_IDSOCSERV_SERVICE_NAME'); ?></strong>:
        </td>

        <td width="60%">
            <input type="text" size="50" maxlength="100" name="tr_idsocserv_service_name" value="<?= $TR_IDSOCSERV_SERVICE_NAME; ?>"/>
        </td>
    </tr>

    <tr>
        <td width="40%" class="adm-detail-content-cell-2">
            <strong><?= GetMessage('TR_IDSOCSERV_SERVICE_LOGO'); ?></strong>:
        </td>

        <td width="60%">
            <input type="text" name="tr_idsocserv_service_logo" size="50" maxlength="100" value="<?= $TR_IDSOCSERV_SERVICE_LOGO; ?>">
            <input type="button" name="browse_0" value="..." onClick="TrIdSocServ_ServiceLogo_BtnClick()">
        </td>
    </tr>

	<? $tabControl->Buttons(); ?>

    <input type="submit" name="Update" value="<?= GetMessage('TR_IDSOCSERV_SETTINGS_SAVE') ?>"/>

	<? $tabControl->End();?>

</form>
