<?php

namespace Trusted\IdSocServ;

use CSocServAuth;
use CSocServAuthManager;
use CSocServOAuthTransport;
use CSocServUtil;
use CFile;
use CMain;
use CModule;
use CUser;
use CUtil;
use Bitrix\Main\Web\HttpClient;
use Trusted\IdSocServ\Utils;

define("SOCSERV_TOO_MANY_USERS_EXIST", 100);

require_once($_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/socialservices/classes/general/authmanager.php");
require_once($_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/socialservices/classes/general/oauthtransport.php");

IncludeModuleLangFile(__FILE__);

class CSocServTrustedId extends CSocServAuth
{
	const ID = "Trusted.Id";

	/** @var CTrustedIdInterface null  */
	protected $entityOAuth = null;

	/**
	 * @param string $code=false
	 * @return CTrustedIdInterface
	 */
	public function getEntityOAuth($code = false)
	{
		if (!$this->entityOAuth)
		{
			$this->entityOAuth = new CTrustedIdInterface();
		}

		if ($code !== false)
		{
			$this->entityOAuth->setCode($code);
		}

		return $this->entityOAuth;
	}

	public function GetSettings()
	{
		//массив опций, как он используется в option.php модулей
		return [
			["trustedid_service_host", GetMessage('TR_IDSOCSERV_LABEL_SERVICE_HOST'), "", array("text", 40)],
			["trustedid_client_id", GetMessage('TR_IDSOCSERV_CLIENT_ID'), "", array("text", 40)],
			["trustedid_client_secret", GetMessage('TR_IDSOCSERV_CLIENT_SECRET'), "", array("text", 40)],
		];
	}

	public function CheckSettings()
	{
		return
			self::GetOption('trustedid_service_host') !== ''
			&& self::GetOption('trustedid_client_id') !== ''
			&& self::GetOption('trustedid_client_secret') !== '';
	}

	public function GetFormHtml($arParams)
	{
		$url = static::getUrl('opener', null, $arParams);

		$phrase = GetMessage("socserv_trustedid_form_note", ["SOCIAL_SERVICE_NAME" => Utils::getServiceName()]);
		if ($arParams["FOR_INTRANET"])
		{
			$phrase = GetMessage("socserv_trustedid_form_note_intranet", ["SOCIAL_SERVICE_NAME" => Utils::getServiceName()]);
		}

		if ($arParams["FOR_INTRANET"])
		{
			return array("ON_CLICK" => 'onclick="BX.util.popup(\''.htmlspecialcharsbx(CUtil::JSEscape($url)).'\', 600, 700)"');
		}
		else
		{
			return '<a href="javascript:void(0)" onclick="BX.util.popup(\''.htmlspecialcharsbx(CUtil::JSEscape($url)).'\', 600, 700)" class="bx-ss-button trusted_id_csoc_serv_button"></a><span class="bx-spacer"></span><span>'.$phrase.'</span>';
		}
	}

	public function GetOnClickJs($arParams)
	{
		$url = static::getUrl('opener', null, $arParams);
		return "BX.util.popup('".CUtil::JSEscape($url)."', 580, 400)";
	}

	public function getUrl($location = 'opener', $addScope = null, $arParams = array())
	{
		$this->entityOAuth = $this->getEntityOAuth();

		if ($this->userId == null)
		{
			$this->entityOAuth->setRefreshToken("skip");
		}

		if ($addScope !== null)
		{
			$this->entityOAuth->addScope($addScope);
		}
		if (IsModuleInstalled('bitrix24') && defined('BX24_HOST_NAME'))
		{
			$redirect_uri = static::getControllerUrl()."/redirect.php";
			$state = $this->getEntityOAuth()->getRedirectUri()."?check_key=".\CSocServAuthManager::getUniqueKey()."&state=";
			$backurl = $GLOBALS["APPLICATION"]->GetCurPageParam('', array("logout", "auth_service_error", "auth_service_id", "backurl"));
			$state .= urlencode('provider='.static::ID.
				"&state=".urlencode("backurl=".urlencode($backurl)
					.'&mode='.$location.(isset($arParams['BACKURL'])
						? '&redirect_url='.urlencode($arParams['BACKURL'])
						: '')
				));
		}
		else
		{
			$state = 'provider='.static::ID.'&site_id='.SITE_ID.'&backurl='.urlencode($GLOBALS["APPLICATION"]->GetCurPageParam('check_key='.\CSocServAuthManager::getUniqueKey(), array("logout", "auth_service_error", "auth_service_id", "backurl"))).'&mode='.$location.(isset($arParams['BACKURL']) ? '&redirect_url='.urlencode($arParams['BACKURL']) : '');
			$redirect_uri = $this->getEntityOAuth()->getRedirectUri();
		}

		return $this->entityOAuth->GetAuthUrl($redirect_uri, $state, $arParams['APIKEY']);
	}

	public function getStorageToken()
	{
		$accessToken = null;
		$userId = intval($this->userId);
		if ($userId > 0)
		{
			$dbSocservUser = \Bitrix\Socialservices\UserTable::getList([
				'filter' => ['=USER_ID' => $userId, "=EXTERNAL_AUTH_ID" => static::ID],
				'select' => ["OATOKEN", "REFRESH_TOKEN", "OATOKEN_EXPIRES"]
			]);
			if ($arOauth = $dbSocservUser->fetch())
			{
				$accessToken = $arOauth["OATOKEN"];

				if (empty($accessToken) || ((intval($arOauth["OATOKEN_EXPIRES"]) > 0) && (intval($arOauth["OATOKEN_EXPIRES"] < intval(time())))))
				{
					if (isset($arOauth['REFRESH_TOKEN']))
					{
						$this->getEntityOAuth()->getNewAccessToken($arOauth['REFRESH_TOKEN'], $userId, true);
					}

					if (($accessToken = $this->getEntityOAuth()->getToken()) === false)
					{
						return null;
					}
				}
			}
		}

		return $accessToken;
	}

	public function prepareUser($arTrustedIdUser, $short = false)
	{
		$first_name = "";
		$last_name = "";
		if (is_array($arTrustedIdUser['name']))
		{
			$first_name = $arTrustedIdUser['name']['givenName'];
			$last_name = $arTrustedIdUser['name']['familyName'];
		}
		elseif ($arTrustedIdUser['name'] <> '')
		{
			$aName = explode(" ", $arTrustedIdUser['name']);
			if ($arTrustedIdUser['given_name'] <> '')
				$first_name = $arTrustedIdUser['given_name'];
			else
				$first_name = $aName[0];

			if ($arTrustedIdUser['family_name'] <> '')
				$last_name = $arTrustedIdUser['family_name'];
			elseif (isset($aName[1]))
				$last_name = $aName[1];
		}
		else {
			if ($arTrustedIdUser['given_name'] <> '')
				$first_name = $arTrustedIdUser['given_name'];
			if ($arTrustedIdUser['family_name'] <> '')
				$last_name = $arTrustedIdUser['family_name'];
		}

		$id = $arTrustedIdUser['id'] ?? $arTrustedIdUser['sub'];
		$email = $arTrustedIdUser['email'];

		if ($arTrustedIdUser['email'] <> '')
		{
			$dbRes = \Bitrix\Main\UserTable::getList(array(
				'filter' => array(
					'=EXTERNAL_AUTH_ID' => 'socservices',
					'=XML_ID' => $email,
				),
				'select' => array('ID'),
				'limit' => 1
			));
			if ($dbRes->fetch())
			{
				$id = $email;
			}
		}

		$login = $id;
		if ($arTrustedIdUser['login'] <> '')
		{
			$login = $arTrustedIdUser['login'];
		}

		$arFields = array(
			'EXTERNAL_AUTH_ID' => static::ID,
			'XML_ID' => $id,
			'LOGIN' => $login,
			'EMAIL' => $email,
			'NAME'=> $first_name,
			'LAST_NAME'=> $last_name,
			'OATOKEN' => $this->entityOAuth->getToken(),
			'OATOKEN_EXPIRES' => $this->entityOAuth->getAccessTokenExpires(),
			'REFRESH_TOKEN' => $this->entityOAuth->getRefreshToken(),
		);

		if ($arTrustedIdUser['gender'] <> '')
		{
			if ($arTrustedIdUser['gender'] == 'male')
			{
				$arFields["PERSONAL_GENDER"] = 'M';
			}
			elseif ($arTrustedIdUser['gender'] == 'female')
			{
				$arFields["PERSONAL_GENDER"] = 'F';
			}
		}

		if (!static::CheckPhotoURI($arTrustedIdUser['picture']))
		{
			$arTrustedIdUser['picture'] = $this->getEntityOAuth()->getServiceHostUrl() . '/' . $arTrustedIdUser['picture'];
		}

		if (!$short && isset($arTrustedIdUser['picture']) && static::CheckPhotoURI($arTrustedIdUser['picture']))
		{
			$arTrustedIdUser['picture'] = preg_replace("/\?.*$/", '', $arTrustedIdUser['picture']);
			$arPic = false;
			if ($arTrustedIdUser['picture'])
			{
				$temp_path =  CFile::GetTempName('', sha1($arTrustedIdUser['picture']));
				$http = new HttpClient();
				$http->setPrivateIp(false);
				if ($http->download($arTrustedIdUser['picture'], $temp_path))
				{
					$arPic = CFile::MakeFileArray($temp_path);
				}
			}

			$arPic = $this->prepareUserImage($arPic);

			if ($arPic)
			{
				$arFields["PERSONAL_PHOTO"] = $arPic;
			}
		}

		$arFields["PERSONAL_WWW"] = isset($arTrustedIdUser['link'])
			? $arTrustedIdUser['link']
			: $arTrustedIdUser['url'];

		if (SITE_ID <> '')
		{
			$arFields["SITE_ID"] = SITE_ID;
		}

		return $arFields;
	}

	public function prepareUserImage($arPic = [])
	{
		if (!$arPic || !is_array($arPic))
		{
			return false;
		}

		if (!isset($arPic["name"]) || !isset($arPic["type"]))
		{
			return false;
		}

		$strFileExt = GetFileExtension($arPic["name"]);
		if ($strFileExt != '')
		{
			return $arPic;
		}

		switch ($arPic["type"]) {
			case "image/jpeg":
				$strFileExt = "jpg";
				break;
			case "image/":
				$strFileExt = "bmp";
				break;
			case "image/gif":
				$strFileExt = "gif";
				break;
			case "image/png":
				$strFileExt = "png";
				break;
			case "image/webp":
				$strFileExt = "webp";
				break;
			case "image/svg+xml":
				$strFileExt = "svg";
				break;
			default:
				$strFileExt = "";
		}

		if ($strFileExt != '')
		{
			$arPic["name"] .= "." . $strFileExt;
		}

		return $arPic;
	}

	public function Authorize()
	{
		global $APPLICATION;
		$APPLICATION->RestartBuffer();

		$bSuccess = false;
		$bProcessState = false;

		$authError = SOCSERV_AUTHORISATION_ERROR;

		if (
			isset($_REQUEST["code"]) && $_REQUEST["code"] <> ''
			&& CSocServAuthManager::CheckUniqueKey()
		)
		{
			$this->getEntityOAuth()->setCode($_REQUEST["code"]);

			$bProcessState = true;

			if ($this->getEntityOAuth()->GetAccessToken() !== false)
			{
				$arTrustedIdUser = $this->getEntityOAuth()->GetCurrentUser();
				if (is_array($arTrustedIdUser) && !isset($arTrustedIdUser["error"]))
				{
					$arFields = self::prepareUser($arTrustedIdUser);
					// no linked user AND more than one record found in existing users
					if (self::countSocUser($arFields) == 0 && self::countExistUsers($arFields) > 1)
					{
						$authError = SOCSERV_TOO_MANY_USERS_EXIST;
					}
					else {
						$authError = $this->AuthorizeUser($arFields);
					}
				}
			}
		}

		if (!$bProcessState)
		{
			unset($_REQUEST["state"]);
		}

		$bSuccess = $authError === true;

		$aRemove = array("logout", "auth_service_error", "auth_service_id", "code", "error_reason", "error", "error_description", "check_key", "current_fieldset");

		if ($bSuccess)
		{
			CSocServUtil::checkOAuthProxyParams();

			$url = ($APPLICATION->GetCurDir() == "/login/") ? "" : $APPLICATION->GetCurDir();
			$mode = 'opener';
			$addParams = true;
			if (isset($_REQUEST["state"]))
			{
				$arState = array();
				parse_str($_REQUEST["state"], $arState);

				if (isset($arState['backurl']) || isset($arState['redirect_url']))
				{
					$url = !empty($arState['redirect_url']) ? $arState['redirect_url'] : $arState['backurl'];
					if (mb_substr($url, 0, 1) !== "#")
					{
						$parseUrl = parse_url($url);

						$urlPath = $parseUrl["path"];
						$arUrlQuery = explode('&', $parseUrl["query"]);

						foreach($arUrlQuery as $key => $value)
						{
							foreach($aRemove as $param)
							{
								if (mb_strpos($value, $param."=") === 0)
								{
									unset($arUrlQuery[$key]);
									break;
								}
							}
						}

						$url = (!empty($arUrlQuery)) ? $urlPath . '?' . implode("&", $arUrlQuery) : $urlPath;
					}
					else
					{
						$addParams = false;
					}
				}

				if (isset($arState['mode']))
				{
					$mode = $arState['mode'];
				}
			}
		}

		if ($authError === SOCSERV_REGISTRATION_DENY)
		{
			$url = (preg_match("/\?/", $url)) ? $url.'&' : $url.'?';
			$url .= 'auth_service_id='.static::ID.'&auth_service_error='.SOCSERV_REGISTRATION_DENY;
		}
		elseif ($bSuccess !== true)
		{
			$url = (isset($urlPath)) ? $urlPath.'?auth_service_id='.static::ID.'&auth_service_error='.$authError : $APPLICATION->GetCurPageParam(('auth_service_id='.static::ID.'&auth_service_error='.$authError), $aRemove);
		}

		if ($addParams && CModule::IncludeModule("socialnetwork") && mb_strpos($url, "current_fieldset=") === false)
		{
			$url = (preg_match("/\?/", $url)) ? $url."&current_fieldset=SOCSERV" : $url."?current_fieldset=SOCSERV";
		}

		$url = CUtil::JSEscape($url);

		if ($addParams)
		{
			$location = ($mode == "opener") ? 'if (window.opener) window.opener.location = \''.$url.'\'; window.close();' : ' window.location = \''.$url.'\';';
		}
		else
		{
			//fix for chrome
			$location = ($mode == "opener") ? 'if (window.opener) window.opener.location = window.opener.location.href + \''.$url.'\'; window.close();' : ' window.location = window.location.href + \''.$url.'\';';
		}

		$JSScript = '
		<script type="text/javascript">
		'.$location.'
		</script>
		';

		echo $JSScript;

		CMain::FinalActions();
	}

	public function setUser($userId)
	{
		$this->getEntityOAuth()->setUser($userId);
	}

	public static function countSocUser($socservUserFields)
	{
		$dbSocUsers = \Bitrix\Socialservices\UserTable::getList([
			'filter' => [
				'=XML_ID'           => $socservUserFields['XML_ID'],
				'=EXTERNAL_AUTH_ID' => $socservUserFields['EXTERNAL_AUTH_ID']
			],
		]);
		$countDbSocUser = 0;
		while ($dbSocUsers->fetch())
		{
			++$countDbSocUser;
		}

		return $countDbSocUser;
	}

	public static function countExistUsers($socservUserFields)
	{
		// check for user with same email
		$dbUsersExist = CUser::GetList("ID", "ASC", array("=EMAIL" => $socservUserFields["EMAIL"], "ACTIVE" => "Y"), array("NAV_PARAMS" => array("nTopCount" => "0")));
		if ($dbUsersExist->NavRecordCount == 1)
		{
			return $dbUsersExist->NavRecordCount;
		}

		$navRecordCountByEmail = $dbUsersExist->NavRecordCount;

		// 0 or several users
		$filter = [
			"LOGIN_EQUAL" => $socservUserFields["LOGIN"],
			"ACTIVE" => "Y"
		];
		if ($dbUsersExist->NavRecordCount > 1)
		{
			$filter["=EMAIL"] = $socservUserFields["EMAIL"];
		}

		// check for user with same login OR same email + login
		$dbUsersExist = CUser::GetList("ID", "ASC", $filter, array("NAV_PARAMS" => array("nTopCount" => "0")));

		if ($dbUsersExist->NavRecordCount == 0) {
			return $navRecordCountByEmail;
		}

		return $dbUsersExist->NavRecordCount;
	}
	
	/**
	 * CSocServAuthManager::checkOldUser
	 */
	public static function checkExistUser(&$socservUserFields)
	{
		if ($socservUserFields["EXTERNAL_AUTH_ID"] !== static::ID)
		{
			return false;
		}

		// check for user with same email
		$dbUsersExist = CUser::GetList("ID", "ASC", array("=EMAIL" => $socservUserFields["EMAIL"], "ACTIVE" => "Y"), array("NAV_PARAMS" => array("nTopCount" => "0")));
		if ($dbUsersExist->NavRecordCount == 1)
		{
			$socservUser = $dbUsersExist->Fetch();
			if ($socservUser)
			{
				return $socservUser["ID"];
			}
		}

		// 0 or several users
		$filter = [
			"LOGIN_EQUAL"  => $socservUserFields["LOGIN"],
			"ACTIVE" => "Y"
		];

		if ($dbUsersExist->NavRecordCount > 1)
		{
			$filter["=EMAIL"] = $socservUserFields["EMAIL"];
		}

		// check for user with same login OR same email + login
		$dbUsersExist = CUser::GetList("ID", "ASC", $filter, array("NAV_PARAMS" => array("nTopCount" => "0")));
		if ($dbUsersExist->NavRecordCount == 1)
		{
			$socservUser = $dbUsersExist->Fetch();
			if ($socservUser)
			{
				return $socservUser["ID"];
			}
		}

		return false;
	}
}


class CTrustedIdInterface extends CSocServOAuthTransport {
	const SERVICE_ID = "Trusted.Id";

	public const CERTS_URL = "/api/oidc/jwks";

	public const JWT_ALG   = ["RS256"];

	const AUTH_URL      = "/api/oidc/auth";
	const TOKEN_URL     = "/api/oidc/token";
	const CONTACTS_URL  = "/api/oidc/me";
	const TOKENINFO_URL = "/api/oidc/introspection";

	const REDIRECT_URI = "/bitrix/tools/oauth/trustedid.php";

	protected $serviceHostUrl = null;

	protected $standardScope = [
		"openid",
		"profile",
		"email",
	];

	protected $scope = [];

	protected $arResult = [];


	protected ?string $idTokenAuth       = null;

	protected ?array  $fetchedPublicKeys = null;

	
	public function __construct($appID = false, $appSecret = false, $code = false, $appHost = false)
	{
		if ($appHost === false)
		{
			$this->setServiceHostUrl(
				trim(CSocServTrustedId::GetOption("trustedid_service_host"))
			);
		}
		if ($appID === false)
		{
			$appID = trim(CSocServTrustedId::GetOption("trustedid_client_id"));
		}

		if ($appSecret === false)
		{
			$appSecret = trim(CSocServTrustedId::GetOption("trustedid_client_secret"));
		}

		$this->scope = $this->standardScope;

		$this->checkSavedScope();

		parent::__construct($appID, $appSecret, $code);
	}

	public function getServiceHostUrl()
	{
		return $this->serviceHostUrl;
	}

	public function setServiceHostUrl($url)
	{
		$this->serviceHostUrl = $url;
		if (substr($this->serviceHostUrl, -1) == '/') {
			$this->serviceHostUrl = mb_substr($this->serviceHostUrl, 0, -1);
		}
	}

	protected function checkSavedScope()
	{
		$savedScope = \Bitrix\Main\Config\Option::get('socialservices', 'saved_scope_'.static::SERVICE_ID, '');
		if ($savedScope)
		{
			$savedScope = unserialize($savedScope, ['allowed_classes' => false]);
			if (is_array($savedScope))
			{
				$this->scope = array_merge($this->scope, $savedScope);
			}
		}
	}

	protected function saveScope()
	{
		$scope = array_unique(array_diff($this->scope, $this->standardScope));
		\Bitrix\Main\Config\Option::set('socialservices', 'saved_scope_'.static::SERVICE_ID, serialize($scope));
	}

	public function addScope($scope)
	{
		parent::addScope($scope);

		$this->saveScope();

		return $this;
	}

	public function getScopeEncode()
	{
		return implode('+', array_map('urlencode', array_unique($this->getScope())));
	}

	public function getResult()
	{
		return $this->arResult;
	}

	public function getError()
	{
		return is_array($this->arResult) && isset($this->arResult['error'])
			? $this->arResult['error']
			: '';
	}

	public function GetAuthUrl($redirect_uri, $state = '', $apiKey = '')
	{
		return $this->serviceHostUrl . static::AUTH_URL.
			"?client_id=".urlencode($this->appID).
			"&redirect_uri=".urlencode($redirect_uri).
			"&scope=".$this->getScopeEncode().
			"&response_type=code".
			"&access_type=offline".
			($this->refresh_token <> '' ? '' : '&approval_prompt=force').
			($state <> '' ? '&state='.urlencode($state) : '').
			($apiKey !== '' ? '&key=' . urlencode($apiKey) : '')
			;
	}

	public function setIdTokenAuth(string $tokenId): void
	{
		$this->idTokenAuth = $tokenId;
	}

	private function fetchPublicKeys(): ?array
	{
		if ($this->fetchedPublicKeys)
		{
			return $this->fetchedPublicKeys;
		}

		try
		{
			$publicKeys = $this->getDecodedJson(self::CERTS_URL);
			if (empty($publicKeys['keys']) || count($publicKeys['keys']) < 1)
			{
				return null;
			}

			$parsedPublicKeys = JWK::parseKeySet($publicKeys['keys']);
			foreach ($parsedPublicKeys as $keyId => $publicKey)
			{
				$details = openssl_pkey_get_details($publicKey);
				$this->fetchedPublicKeys[$keyId] = $details['key'];
			}

			return $this->fetchedPublicKeys;
		}
		catch (\Exception $e)
		{
		}

		return null;
	}

	private function decodeIdentityToken(string $identityToken): array
		{
			$publicKeys = $this->fetchPublicKeys();
			if ($publicKeys === null)
			{
				return [];
			}

			try
			{
				return (array)JWT::decode($identityToken, $publicKeys, self::JWT_ALG);
			}
			catch (UnexpectedValueException $exception)
			{
				return [];
			}
		}

	public function GetAccessToken($redirect_uri = false)
	{
		$tokens = $this->getStorageTokens();

		if (is_array($tokens))
		{
			$this->access_token = $tokens["OATOKEN"];
			$this->accessTokenExpires = $tokens["OATOKEN_EXPIRES"];

			if (!$this->code)
			{
				if ($this->checkAccessToken())
				{
					return true;
				}
				elseif (isset($tokens["REFRESH_TOKEN"]))
				{
					if ($this->getNewAccessToken($tokens["REFRESH_TOKEN"], $this->userId, true))
					{
						return true;
					}
				}
			}

			$this->deleteStorageTokens();
		}

		if ($this->code === false)
		{
			return false;
		}

		if ($redirect_uri === false)
		{
			if (IsModuleInstalled('bitrix24') && defined('BX24_HOST_NAME'))
			{
				$redirect_uri = CSocServTrustedId::getControllerUrl()."/redirect.php";
			}
			else
			{
				$redirect_uri = $this->getRedirectUri();
			}
		}

		$authParams = [
			"client_id" => $this->appID,
			"code" => $this->code,
			"redirect_uri" => $redirect_uri,
			"grant_type" => "authorization_code",
			"client_secret" => $this->appSecret,
		];

		$this->arResult = $this->getDecodedJson($this->serviceHostUrl . static::TOKEN_URL, $authParams);

		if (isset($this->arResult["access_token"]) && $this->arResult["access_token"] <> '')
		{
			if (isset($this->arResult["refresh_token"]) && $this->arResult["refresh_token"] <> '')
			{
				$this->refresh_token = $this->arResult["refresh_token"];
			}
			$this->access_token = $this->arResult["access_token"];
			$this->accessTokenExpires = $this->arResult["expires_in"] + time();

			$_SESSION["OAUTH_DATA"] = array(
				"OATOKEN" => $this->access_token,
				"OATOKEN_EXPIRES" => $this->accessTokenExpires,
				"REFRESH_TOKEN" => $this->refresh_token,
			);

			return true;
		}
		return false;
	}

	public function GetCurrentUser()
	{

		if ($this->idTokenAuth)
		{
			$identity = $this->decodeIdentityToken($this->idTokenAuth);

			return $identity ?: false;
		}


		if ($this->access_token === false)
			return false;

		$result = $this->getDecodedJson($this->serviceHostUrl . static::CONTACTS_URL.'?access_token='.urlencode($this->access_token));

		if ($result)
		{
			$result["access_token"] = $this->access_token;
			$result["refresh_token"] = $this->refresh_token;
			$result["expires_in"] = $this->accessTokenExpires;
		}

		return $result;
	}

	public function GetAppInfo()
	{

		if ($this->idTokenAuth)
		{
			$identity = $this->decodeIdentityToken($this->idTokenAuth);
			if (empty($identity['aud']))
			{
				return false;
			}

			return [
				'id' => $identity['aud'],
			];
		}

		if ($this->access_token === false)
		{
			return false;
		}

		$result = $this->getDecodedJson($this->serviceHostUrl . static::TOKENINFO_URL.'?access_token='.urlencode($this->access_token));

		if ($result && $result["audience"])
		{
			$result["id"] = $result["audience"];
		}

		return $result;
	}


	public function getNewAccessToken($refreshToken = false, $userId = 0, $save = false)
	{
		if ($this->appID == false || $this->appSecret == false)
		{
			return false;
		}

		if ($refreshToken === false)
		{
			$refreshToken = $this->refresh_token;
		}

		$this->arResult = $this->getDecodedJson($this->serviceHostUrl . static::TOKEN_URL, [
			"client_id" => $this->appID,
			"refresh_token"=>$refreshToken,
			"grant_type"=>"refresh_token",
			"client_secret" => $this->appSecret,
		]);

		if (isset($this->arResult["access_token"]) && $this->arResult["access_token"] <> '')
		{
			$this->access_token = $this->arResult["access_token"];
			$this->accessTokenExpires = $this->arResult["expires_in"] + time();
			if ($save && intval($userId) > 0)
			{
				$dbSocservUser = \Bitrix\Socialservices\UserTable::getList(array(
					'filter' => array(
						'=EXTERNAL_AUTH_ID' => static::SERVICE_ID,
						'=USER_ID' => $userId,
					),
					'select' => array("ID")
				));
				if ($arOauth = $dbSocservUser->Fetch())
				{
					\Bitrix\Socialservices\UserTable::update($arOauth["ID"], array(
							"OATOKEN" => $this->access_token,
							"OATOKEN_EXPIRES" => $this->accessTokenExpires)
					);
				}
			}

			return true;
		}

		return false;
	}

	public function getRedirectUri()
	{
		return static::URN2URI(static::REDIRECT_URI);
	}

	public static function URN2URI($urn, $server_name = '')
	{
		/** @global CMain $APPLICATION */
		global $APPLICATION;

		if(preg_match("/^[a-z]+:\\/\\//", $urn))
		{
			$uri = $urn;
		}
		else
		{
			$proto = "https://";

			if($server_name <> '')
				$server_name = preg_replace("/:(443|80)$/", "", $server_name);
			else
				$server_name = preg_replace("/:(443|80)$/", "", $_SERVER["HTTP_HOST"]);

			$uri = $proto.$server_name.$urn;
		}
		return $uri;
	}
}
