<?php

namespace Trusted\IdSocServ;

use \Bitrix\Main\Application;
use Bitrix\Main\Localization\Loc;
use Bitrix\Main\Config\Option;

Loc::loadMessages(__FILE__);

/**
 * Various utility functions
 */
class Utils {

	/**
	 * Получение названия сервиса
	 *
	 * @return string
	 */
	public static function getServiceName()
	{
		return Option::get(
			TR_IDSOCSERV_MODULE_ID,
			TR_IDSOCSERV_SETTINGS_SERVICE_NAME,
			GetMessage("TR_IDSOCSERV_DEFAULT_SERVICE_NAME")
		);
	}

	/**
	 * Получение пути лого сервиса
	 *
	 * @return string
	 */
	public static function getServiceLogo()
	{
		return Option::get(
			TR_IDSOCSERV_MODULE_ID,
			TR_IDSOCSERV_SETTINGS_SERVICE_LOGO
		);
	}

	/**
	 * Задание названия сервиса
	 *
	 * @return string
	 * @var string $name
	 *
	 */
	public static function setServiceName($name = "")
	{
		Option::set(
			TR_IDSOCSERV_MODULE_ID,
			TR_IDSOCSERV_SETTINGS_SERVICE_NAME,
			$name
		);
	}

	/**
	 * Задание пути лого сервиса
	 *
	 * @return string
	 * @var string $path
	 *
	 */
	public static function setServiceLogo($path = "")
	{
		Option::set(
			TR_IDSOCSERV_MODULE_ID,
			TR_IDSOCSERV_SETTINGS_SERVICE_LOGO,
			$path
		);
	}
}
