<?php

use Bitrix\Main\Localization\Loc;
use Bitrix\Main\ModuleManager;

class trusted_idsocserv extends CModule
{
    const MODULE_ID = "trusted.idsocserv";
    public $MODULE_ID = "trusted.idsocserv";
	public $MODULE_NAME;
	public $MODULE_DESCRIPTION;
	public $MODULE_VERSION;
	public $MODULE_VERSION_DATE;
	public $PARTNER_NAME;
	public $PARTNER_URI;

    function trusted_idsocserv()
    {
        self::__construct();
    }

    function __construct()
    {
        $arModuleVersion = array();
        include __DIR__ . "/version.php";
        $this->MODULE_ID = "trusted.idsocserv";
        $this->MODULE_NAME = GetMessage("TR_IDSOCSERV_MODULE_NAME");
        $this->MODULE_DESCRIPTION = GetMessage("TR_IDSOCSERV_MODULE_DESCRIPTION");
        $this->MODULE_VERSION = $arModuleVersion["VERSION"];
        $this->MODULE_VERSION_DATE = $arModuleVersion["VERSION_DATE"];
        $this->PARTNER_NAME = GetMessage("TR_IDSOCSERV_PARTNER_NAME");
        $this->PARTNER_URI = GetMessage("TR_IDSOCSERV_PARTNER_URI");
    }

    function RegisterEventHandlers()
    {
	    RegisterModuleDependences("main", "OnPageStart", self::MODULE_ID, "\Trusted\IdSocServ\CSocServDescription", "OnPageStartHandler");
	    RegisterModuleDependences("socialservices", "OnFindSocialservicesUser", self::MODULE_ID, "\Trusted\IdSocServ\CSocServTrustedId", "checkExistUser");
    }

    function UnRegisterEventHandlers()
    {
	    UnRegisterModuleDependences("main", "OnPageStart", self::MODULE_ID, "\Trusted\IdSocServ\CSocServDescription", "OnPageStartHandler");
	    UnRegisterModuleDependences("socialservices", "OnFindSocialservicesUser", self::MODULE_ID, "\Trusted\IdSocServ\CSocServTrustedId", "checkExistUser");
    }

    //needed to pass check on install tr ca docs
    // to do: add check version with tr ca docs core
    function CoreAndModuleAreCompatible() {
        return "ok";
    }

    function DoInstall()
    {
	    global $APPLICATION;

	    if (!$this->SocialServicesSupport()) {
		    $APPLICATION->IncludeAdminFile(
			    Loc::getMessage("MOD_INSTALL_TITLE"),
			    $_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/" . $this->MODULE_ID . "/install/step_no_compatibility.php"
		    );
	    }

        $this->InstallFiles();
        $this->RegisterEventHandlers();
        ModuleManager::RegisterModule(self::MODULE_ID);
    }

    function DoUninstall()
    {
		global $APPLICATION;

        $this->UnInstallFiles();
        $this->UnRegisterEventHandlers();
        ModuleManager::UnRegisterModule(self::MODULE_ID);
	    $APPLICATION->IncludeAdminFile(
		    Loc::getMessage("MOD_UNINSTALL_TITLE"),
		    $_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/" . $this->MODULE_ID . "/install/unstep.php"
	    );
    }

	public function SocialServicesSupport()
	{
		return IsModuleInstalled("socialservices");
	}

    function InstallFiles()
    {
        CopyDirFiles(
            $_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/" . self::MODULE_ID . "/install/themes",
            $_SERVER["DOCUMENT_ROOT"] . "/bitrix/themes",
            true, true
        );
	    CopyDirFiles(
		    $_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/" . self::MODULE_ID . "/install/tools",
			$_SERVER["DOCUMENT_ROOT"] . "/bitrix/tools",
			true, true
	    );
        return true;
    }

    function UnInstallFiles()
    {
        DeleteDirFiles(
            $_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/" . self::MODULE_ID . "/install/themes/.default/",
            $_SERVER["DOCUMENT_ROOT"] . "/bitrix/themes/.default/"
        );
        DeleteDirFilesEx("/bitrix/themes/.default/icons/" . self::MODULE_ID);
	    DeleteDirFiles(
		    $_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/" . self::MODULE_ID . "/install/tools/oauth/",
		    $_SERVER["DOCUMENT_ROOT"] . "/bitrix/tools/oauth/"
	    );
        return true;
    }

}

